/*
C-code for the test for time reversibility described in:
 
Diks, C., Houwelingen, J.C. van, Takens, F. and DeGoede, J. (1995) 
Reversibility as a criterion for discriminating time series, Physics Letters 
A 201, 221-228

Code uses the block method described in my book:

Diks, C. (1999) Nonlinear Time Series Analysis: Methods and Applications, 
Vol. 4 in series "Nonlinear Time Series and Chaos", edited by H. Tong 
(World Scientific, Singapore). ISBN: 9810235054.

Cees Diks, 1995 - 2008, this version: June 2008
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double ranu()
{
  return rand()/(double)(RAND_MAX);
}

int main()
{
  char filename[128], kind[32], type[32], ident[32];
  int i, j, k, N, nblock=0, lblock, ntau, m, ib, jb, *bin, pw, count=0, sample,
      nsample, ntot;
  long seed;
  double *x, h, mean=0.0, var=0.0, sigma, **aa, tmp, dis1, dis2, Q=0.0, Qe,
 	 t0, dt;
  FILE *infil, *outfil;
  
  printf("filename : "); scanf("%s", filename);

 if ((infil = fopen(filename,"r"))==NULL)
  {
     fprintf(stderr,"File reading error. Exiting...\n");
     exit(1);
  }

  i=0;

  while (fscanf(infil,"%lf",&tmp)!=EOF)
  {
    i++;
  }

  fclose(infil);

  N = i;

  fprintf(stderr,"%d values read\n",N);
  
  x = (double *) malloc(N*sizeof(double));

  i=0;
  if ((infil = fopen(filename,"r"))==NULL)
  {
     fprintf(stderr,"File reading error. Exiting...\n");
  }
  else 
  {
    while (fscanf(infil,"%lf",&x[i])!=EOF)
      i++;
  }

  if (i!=N)
  {
    fprintf(stderr,"Error: wrong number of data read. Exiting...\n");
    exit(1);
  } 

  fclose(infil);
  
  for (i=0;i!=N;i++)
  {
    var += x[i]*x[i];
    mean += x[i];
  }
  
  mean /= (double)(N);
  var = (var - N*mean*mean)/(double)(N-1);
  
  sigma = sqrt(var);

  for (i=0;i!=N;i++)
    x[i] /= sigma;

  i = 0;
  while (i <= 0)
  {
    printf("ntau       : "); scanf("%d", &ntau);
    printf("emb.dim. m : "); scanf("%d", &m);
    i = N-(m-1)*ntau;
    if (i>1)
      printf("Total of %d delay vector(s)\n", i);
    else
      printf("Window: (m-1)*ntau = %d, should be smaller than %d\n", N-i, N);
  }
  N = i;
  
  lblock = 0;
  while (nblock > N || nblock < 1)
  {
    printf("# of blocks  : "); scanf("%d", &nblock);
    if (nblock > N || nblock < 1)
      printf("# of blocks should be in the range 1,...,%d\n", N);
    else
      lblock=N/nblock;
  }
  
  sample = -1;
  while (sample != 0 && sample != 1)
  {
    printf("Complete distrib (0) or sample (1) : ");
    scanf("%d", &sample);
  }
  
  if (sample == 1)
  {
    printf("seed      : "); scanf("%ld", &seed);
    printf("# samples : "); scanf("%d", &nsample);
  }
  srand(seed);

  printf("bandwidth  : "); scanf("%lf", &h);
  
  printf("Tracking %d block-block pairs.\n", (nblock*(nblock-1))/2);
  
  aa = (double **)malloc(nblock*sizeof(double*));
  if (aa == NULL)
  {
    fprintf(stderr,"Malloc failed. Exiting...\n");
    exit(1);
  }

  for (i=0;i!=nblock;i++)
  {
    aa[i] = (double *)malloc(nblock*sizeof(double));
    if (aa[i] == NULL)
    {
      fprintf(stderr,"Malloc failed. Exiting...\n");
      exit(1);
    }
  }
  
  bin = (int *)malloc(nblock*sizeof(int));
  if (bin == NULL)
  {
    fprintf(stderr,"Malloc failed. Exiting...\n");
    exit(1);
  }

  for (i=0;i!=nblock;i++)
  {
    bin[i] = 0;
    for (j=0;j!=nblock;j++)
      aa[i][j]=0.0;
  }

  
  for (ib=0;ib!=nblock-1;ib++)
    for (jb=ib+1;jb!=nblock;jb++)
    {
      count ++;
      for (i=lblock*ib;i!=lblock*(ib+1);i++)
        for (j=lblock*jb;j!=lblock*(jb+1);j++)
        {
          dis1=0;
          dis2=0;
          for (k=0;k!=m;k++)
          {
            tmp = (x[i+ntau*k]-x[j+ntau*k])/(2.0*h);
            dis1 += tmp*tmp;
            tmp = (x[i+ntau*k]-x[j+ntau*(m-1-k)])/(2.0*h);
            dis2 += tmp*tmp;
          }
          aa[ib][jb] += exp(-dis1) - exp(-dis2);
        }
      fprintf(stderr,"\r %d", count);
    }

  count = 0;
  
  /* normalization */

  for (ib=0;ib!=nblock-1;ib++)
    for (jb=ib+1;jb!=nblock;jb++)
      aa[ib][jb] /= (lblock*lblock*nblock*(nblock-1))/2.0;

  for (ib=0;ib!=nblock-1;ib++)
    for (jb=ib+1;jb!=nblock;jb++)
      Q += aa[ib][jb];
  
  Qe = Q;

  printf("\nQ = %1.12f\n", Q);
   
  //if ( (outfil = fopen("rever.dat","w")) == NULL)
  //{
  //  printf("Warning: unable to open output file\n");
  //}

  if (sample == 0)
  {
    //fprintf(outfil,"%1.12f\n", Q);
    pw = pow(2,nblock-1);  
    printf("Determining conditional null distribution, %d configurations\n", pw);
    count = 1;
    for (i=1;i<pw;i++)
    {
      fprintf(stderr,"\r %d", i+1);
      k = i;

      for (j=0;j!=nblock;j++)
      {
        tmp = fmod(k,2);
        if (tmp!=0) bin[j]=1;
        else bin[j] = -1;
        k /= 2;
      } 
      Q = 0;
      for (ib=0;ib!=nblock-1;ib++)
        for (jb=ib+1;jb!=nblock;jb++)
          Q += aa[ib][jb]*bin[ib]*bin[jb];
      if (Q>=Qe) count ++;
      //fprintf(outfil,"%1.12f\n", Q);
    }
  }
  else		/* sample == 1 */
  {
    count = 1; /* consider the original time series as the first sample */
    pw = nsample;
    nsample--;
    fprintf(stderr,"Considering %d configurations\n", nsample);
    for (i=0;i!=nsample;i++)
    {
      fprintf(stderr,"\r %d", i+1);
      for (j=0;j!=nblock;j++)
      {
        if (ranu() < 0.5) bin[j] = -1;
        else bin[j] = 1;
      } 
      Q = 0;
      for (ib=0;ib!=nblock-1;ib++)
        for (jb=ib+1;jb!=nblock;jb++)
          Q += aa[ib][jb]*bin[ib]*bin[jb];
      if (Q>=Qe) count ++;
      //fprintf(outfil,"%1.12f\n", Q);
    }
  }

  //fclose(outfil);
  
  printf("\nAt Q=%1.12f, p=%1.12f\n", Qe, (double)(count)/(double)(pw) );
  
  return 0;  
}
